<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-04-08 10:32
 */
interface StageDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Stage 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param stage primary key
 	 */
	public function delete($stageId);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Stage stage
 	 */
	public function insert($stage);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Stage stage
 	 */
	public function update($stage);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByStagename($value);

	public function queryByProductId($value);

	public function queryByTotalhour($value);

	public function queryByUserid($value);

	public function queryByConditions($value);

	public function queryByDate($value);


	public function deleteByStagename($value);

	public function deleteByProductId($value);

	public function deleteByTotalhour($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);

	public function deleteByDate($value);


}
?>